/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;
import processing.core.PCanvas;
import processing.core.PException;
import processing.core.PFont;
import processing.core.PImage;

public abstract class PMIDlet
extends MIDlet
implements Runnable,
CommandListener {
    public static final int CENTER = 0;
    public static final int CENTER_RADIUS = 1;
    public static final int CORNER = 2;
    public static final int CORNERS = 3;
    public static final int POINTS = 0;
    public static final int LINES = 1;
    public static final int LINE_STRIP = 2;
    public static final int LINE_LOOP = 3;
    public static final int TRIANGLES = 4;
    public static final int TRIANGLE_STRIP = 5;
    public static final int QUADS = 6;
    public static final int QUAD_STRIP = 7;
    public static final int POLYGON = 8;
    public static final int UP = 1;
    public static final int DOWN = 6;
    public static final int LEFT = 2;
    public static final int RIGHT = 5;
    public static final int FIRE = 8;
    public static final int GAME_A = 9;
    public static final int GAME_B = 10;
    public static final int GAME_C = 11;
    public static final int GAME_D = 12;
    public static final int SOFTKEY1 = -6;
    public static final int SOFTKEY2 = -7;
    public static final int SEND = -10;
    public static final String SOFTKEY1_NAME = "SOFT1";
    public static final String SOFTKEY2_NAME = "SOFT2";
    public static final String SEND_NAME = "SEND";
    public static final int FACE_SYSTEM = 0;
    public static final int FACE_MONOSPACE = 32;
    public static final int FACE_PROPORTIONAL = 64;
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_UNDERLINED = 4;
    public static final int SIZE_SMALL = 8;
    public static final int SIZE_MEDIUM = 0;
    public static final int SIZE_LARGE = 16;
    public static final int RGB = 0;
    public static final int HSB = 1;
    protected boolean pointerPressed;
    protected int pointerX;
    protected int pointerY;
    protected char key;
    protected int keyCode;
    protected int rawKeyCode;
    protected boolean keyPressed;
    public static final int MULTITAP_KEY_SPACE = 0;
    public static final int MULTITAP_KEY_UPPER = 1;
    public static final String MULTITAP_PUNCTUATION = ".,?!'\"-_:;/()@&#$%*+<=>^";
    protected boolean multitap;
    protected String multitapText;
    protected char[] multitapKeySettings;
    protected char[] multitapBuffer;
    protected int multitapBufferIndex;
    protected int multitapBufferLength;
    protected int multitapLastEdit;
    protected int multitapEditDuration;
    protected boolean multitapIsUpperCase;
    protected String multitapPunctuation;
    protected int framerate;
    protected int frameCount;
    public PCanvas canvas;
    public Command cmdExit;
    public Command cmdCustom;
    public Display display = Display.getDisplay((MIDlet)this);
    public int width;
    public int height;
    private Runtime runtime = Runtime.getRuntime();
    private Thread thread;
    private boolean setup;
    private boolean running;
    private boolean redraw;
    private long startTime;
    private long lastFrameTime;
    private int msPerFrame;
    private PFont defaultFont;
    private Calendar calendar;
    private Random random;
    public static final byte EVENT_KEY_PRESSED = 1;
    public static final byte EVENT_KEY_RELEASED = 2;
    public static final byte EVENT_SOFTKEY_PRESSED = 3;
    public static final byte EVENT_LIBRARY = 4;
    public static final byte EVENT_POINTER_PRESSED = 5;
    public static final byte EVENT_POINTER_DRAGGED = 6;
    public static final byte EVENT_POINTER_RELEASED = 7;
    private byte[] events;
    private byte[] eventsClone;
    private int eventsLength;
    private int[] eventValues;
    private int[] eventValuesClone;
    private Object[] eventData;
    private Object[] eventDataClone;
    public static final int FP_PRECISION = 8;
    public static final int ONE = 256;
    public static final int PI = 804;
    public static final int TWO_PI = 1608;
    public static final int HALF_PI = 402;
    public static final int[] sin = new int[]{0, 4, 8, 13, 17, 22, 26, 31, 35, 40, 44, 48, 53, 57, 61, 66, 70, 74, 79, 83, 87, 91, 95, 100, 104, 108, 112, 116, 120, 124, 128, 131, 135, 139, 143, 146, 150, 154, 157, 161, 164, 167, 171, 174, 177, 181, 184, 187, 190, 193, 196, 198, 201, 204, 207, 209, 212, 214, 217, 219, 221, 223, 226, 228, 230, 232, 233, 235, 237, 238, 240, 242, 243, 244, 246, 247, 248, 249, 250, 251, 252, 252, 253, 254, 254, 255, 255, 255, 255, 255, 256, 255, 255, 255, 255, 255, 254, 254, 253, 252, 252, 251, 250, 249, 248, 247, 246, 244, 243, 242, 240, 238, 237, 235, 233, 232, 230, 228, 226, 223, 221, 219, 217, 214, 212, 209, 207, 204, 201, 198, 196, 193, 190, 187, 184, 181, 177, 174, 171, 167, 164, 161, 157, 154, 150, 146, 143, 139, 135, 131, 128, 124, 120, 116, 112, 108, 104, 100, 95, 91, 87, 83, 79, 74, 70, 66, 61, 57, 53, 48, 44, 40, 35, 31, 26, 22, 17, 13, 8, 4, 0, -4, -8, -13, -17, -22, -26, -31, -35, -40, -44, -48, -53, -57, -61, -66, -70, -74, -79, -83, -87, -91, -95, -100, -104, -108, -112, -116, -120, -124, -128, -131, -135, -139, -143, -146, -150, -154, -157, -161, -164, -167, -171, -174, -177, -181, -184, -187, -190, -193, -196, -198, -201, -204, -207, -209, -212, -214, -217, -219, -221, -223, -226, -228, -230, -232, -233, -235, -237, -238, -240, -242, -243, -244, -246, -247, -248, -249, -250, -251, -252, -252, -253, -254, -254, -255, -255, -255, -255, -255, -256, -255, -255, -255, -255, -255, -254, -254, -253, -252, -252, -251, -250, -249, -248, -247, -246, -244, -243, -242, -240, -238, -237, -235, -233, -232, -230, -228, -226, -223, -221, -219, -217, -214, -212, -209, -207, -204, -201, -198, -196, -193, -190, -187, -184, -181, -177, -174, -171, -167, -164, -161, -157, -154, -150, -146, -143, -139, -135, -131, -128, -124, -120, -116, -112, -108, -104, -100, -95, -91, -87, -83, -79, -74, -70, -66, -61, -57, -53, -48, -44, -40, -35, -31, -26, -22, -17, -13, -8, -4};
    private static int[] crc_table;

    public final Canvas getCanvas() {
        return this.canvas;
    }

    public final void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdExit) {
            this.exit();
        } else if (command == this.cmdCustom) {
            this.enqueueEvent((byte)3, 0, this.cmdCustom.getLabel());
        }
    }

    public void softkeyPressed(String string) {
    }

    public final void softkey(String string) {
        if (this.cmdCustom != null) {
            this.canvas.removeCommand(this.cmdCustom);
        }
        if (string != null) {
            this.cmdCustom = new Command(string, 1, 2);
            this.canvas.addCommand(this.cmdCustom);
        }
    }

    public final void exit() {
        try {
            this.destroyApp(true);
            this.notifyDestroyed();
        }
        catch (MIDletStateChangeException mIDletStateChangeException) {
            // empty catch block
        }
    }

    protected final void destroyApp(boolean bl) throws MIDletStateChangeException {
        this.running = false;
        this.destroy();
    }

    protected final void pauseApp() {
        this.running = false;
    }

    protected final void startApp() throws MIDletStateChangeException {
        if (this.canvas == null) {
            this.cmdExit = new Command("Exit", 7, 1);
            this.canvas = new PCanvas(this);
            this.canvas.addCommand(this.cmdExit);
            this.canvas.setCommandListener(this);
            this.width = this.canvas.getWidth();
            this.height = this.canvas.getHeight();
            this.startTime = System.currentTimeMillis();
            this.msPerFrame = 1;
            this.multitapBuffer = new char[64];
            this.multitapText = "";
            this.multitapKeySettings = new char[]{'#', '*'};
            this.multitapPunctuation = MULTITAP_PUNCTUATION;
            this.multitapEditDuration = 1000;
            this.events = new byte[8];
            this.eventsClone = new byte[8];
            this.eventValues = new int[8];
            this.eventValuesClone = new int[8];
            this.eventData = new Object[8];
            this.eventDataClone = new Object[8];
            this.setup = false;
            this.running = true;
        }
        this.redraw = true;
        this.display.setCurrent((Displayable)this.canvas);
    }

    protected final synchronized void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public final void run() {
        try {
            if (!this.setup) {
                this.setup();
                this.lastFrameTime = this.startTime - (long)this.msPerFrame;
                this.setup = true;
            }
            do {
                long l = System.currentTimeMillis();
                int n = Math.max(1, (int)(l - this.lastFrameTime));
                this.dequeueEvents();
                if (this.redraw || this.running && n >= this.msPerFrame) {
                    this.canvas.resetMatrix();
                    this.draw();
                    this.runtime.gc();
                    this.canvas.repaint();
                    this.canvas.serviceRepaints();
                    this.lastFrameTime = l;
                    this.framerate = 1000 / n;
                    ++this.frameCount;
                    this.redraw = false;
                }
                Thread.yield();
            } while (this.running || this.eventsLength > 0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Form form = new Form("Exception");
            form.append(throwable.toString());
            form.setCommandListener((CommandListener)this);
            form.addCommand(this.cmdExit);
            this.display.setCurrent((Displayable)form);
        }
        this.thread = null;
    }

    public void setup() {
    }

    public void suspend() {
    }

    public void resume() {
    }

    public void destroy() {
    }

    public void draw() {
    }

    public void libraryEvent(Object object, int n, Object object2) {
    }

    public final void enqueueLibraryEvent(Object object, int n, Object object2) {
        this.enqueueEvent((byte)4, n, new Object[]{object, object2});
    }

    public final synchronized void enqueueEvent(byte by, int n, Object object) {
        ++this.eventsLength;
        if (this.eventsLength > this.events.length) {
            byte[] byArray = this.events;
            int[] nArray = this.eventValues;
            Object[] objectArray = this.eventData;
            this.events = new byte[byArray.length * 2];
            this.eventValues = new int[this.events.length];
            this.eventData = new Object[this.events.length];
            System.arraycopy(byArray, 0, this.events, 0, this.eventsLength - 1);
            System.arraycopy(nArray, 0, this.eventValues, 0, this.eventsLength - 1);
            System.arraycopy(objectArray, 0, this.eventData, 0, this.eventsLength - 1);
        }
        this.events[this.eventsLength - 1] = by;
        this.eventValues[this.eventsLength - 1] = n;
        this.eventData[this.eventsLength - 1] = object;
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dequeueEvents() {
        int n;
        PMIDlet pMIDlet = this;
        synchronized (pMIDlet) {
            n = this.eventsLength;
            this.eventsLength = 0;
            if (this.eventsClone.length < n) {
                this.eventsClone = new byte[this.events.length];
                this.eventValuesClone = new int[this.events.length];
                this.eventDataClone = new Object[this.events.length];
            }
            System.arraycopy(this.events, 0, this.eventsClone, 0, n);
            System.arraycopy(this.eventValues, 0, this.eventValuesClone, 0, n);
            System.arraycopy(this.eventData, 0, this.eventDataClone, 0, n);
            for (int i = n - 1; i >= 0; --i) {
                this.eventData[i] = null;
            }
        }
        for (int i = 0; i < n; ++i) {
            switch (this.eventsClone[i]) {
                case 1: {
                    this.keyPressed(this.eventValuesClone[i]);
                    break;
                }
                case 2: {
                    this.keyReleased(this.eventValuesClone[i]);
                    break;
                }
                case 3: {
                    this.softkeyPressed((String)this.eventDataClone[i]);
                    break;
                }
                case 4: {
                    Object[] objectArray = (Object[])this.eventDataClone[i];
                    this.libraryEvent(objectArray[0], this.eventValuesClone[i], objectArray[1]);
                    Object object = objectArray[0];
                    synchronized (object) {
                        objectArray[0].notifyAll();
                        break;
                    }
                }
                case 5: {
                    this.pointerPressed = true;
                    this.pointerX = this.eventValuesClone[i] >> 16;
                    this.pointerY = this.eventValuesClone[i] & 0xFFFF;
                    this.pointerPressed();
                    break;
                }
                case 6: {
                    this.pointerX = this.eventValuesClone[i] >> 16;
                    this.pointerY = this.eventValuesClone[i] & 0xFFFF;
                    this.pointerDragged();
                    break;
                }
                case 7: {
                    this.pointerPressed = false;
                    this.pointerX = this.eventValuesClone[i] >> 16;
                    this.pointerY = this.eventValuesClone[i] & 0xFFFF;
                    this.pointerReleased();
                }
            }
            this.eventDataClone[i] = null;
        }
    }

    private void key(int n) {
        this.rawKeyCode = n;
        if (n >= 48 && n <= 57) {
            this.key = (char)(48 + (n - 48));
            this.keyCode = this.key;
        } else {
            switch (n) {
                case 35: {
                    this.key = (char)35;
                    this.keyCode = this.key;
                    break;
                }
                case 42: {
                    this.key = (char)42;
                    this.keyCode = this.key;
                    break;
                }
                default: {
                    String string = this.canvas.getKeyName(n);
                    if (string.equals(SOFTKEY1_NAME)) {
                        this.key = (char)65535;
                        this.keyCode = -6;
                        break;
                    }
                    if (string.equals(SOFTKEY2_NAME)) {
                        this.key = (char)65535;
                        this.keyCode = -7;
                        break;
                    }
                    if (string.equals(SEND_NAME)) {
                        this.key = (char)65535;
                        this.keyCode = -10;
                        break;
                    }
                    this.key = (char)65535;
                    this.keyCode = this.canvas.getGameAction(n);
                    if (this.keyCode != 0) break;
                    this.keyCode = n;
                }
            }
        }
    }

    private void keyPressed(int n) {
        this.keyPressed = true;
        if (this.multitap) {
            this.multitapKeyPressed(n);
        }
        this.key(n);
        this.keyPressed();
    }

    private void keyReleased(int n) {
        this.keyPressed = false;
        this.key(n);
        this.keyReleased();
    }

    public void keyPressed() {
    }

    public void keyReleased() {
    }

    public void pointerPressed() {
    }

    public void pointerDragged() {
    }

    public void pointerReleased() {
    }

    public final void redraw() {
        this.redraw = true;
    }

    public final void loop() {
        this.running = true;
    }

    public final void noLoop() {
        this.running = false;
        this.redraw = true;
    }

    public final void size(int n, int n2) {
    }

    public final void framerate(int n) {
        this.msPerFrame = 1000 / n;
        if (this.msPerFrame <= 0) {
            this.msPerFrame = 1;
        }
    }

    public final String getProperty(String string) {
        String string2 = this.getAppProperty(string);
        if (string2 == null) {
            string2 = System.getProperty(string);
        }
        return string2;
    }

    public final String textInput() {
        return this.textInput("Text Input", null, 256);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String textInput(String string, String string2, int n) {
        TextInputForm textInputForm = new TextInputForm(this, string, string2, n, 0);
        PMIDlet pMIDlet = this;
        synchronized (pMIDlet) {
            this.display.setCurrent((Displayable)textInputForm);
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.display.setCurrent((Displayable)this.canvas);
        return textInputForm.getString();
    }

    public final void multitap() {
        this.multitap = true;
    }

    public final void noMultitap() {
        this.multitap = false;
    }

    public final void multitapClear() {
        this.multitapBufferIndex = 0;
        this.multitapBufferLength = 0;
        this.multitapText = "";
    }

    public final void multitapDeleteChar() {
        if (this.multitapBufferIndex > 0) {
            System.arraycopy(this.multitapBuffer, this.multitapBufferIndex, this.multitapBuffer, this.multitapBufferIndex - 1, this.multitapBufferLength - this.multitapBufferIndex);
            --this.multitapBufferLength;
            --this.multitapBufferIndex;
            this.multitapLastEdit = 0;
        }
        this.multitapText = new String(this.multitapBuffer, 0, this.multitapBufferLength);
    }

    private char multitapUpperKeyPressed(boolean bl, char c) {
        boolean bl2 = this.multitapIsUpperCase = !this.multitapIsUpperCase;
        if (bl) {
            if (c == this.multitapKeySettings[1]) {
                this.multitapDeleteChar();
                this.multitapLastEdit = this.millis();
                c = '\u0000';
            } else {
                c = this.multitapKeySettings[1];
            }
        } else {
            this.multitapLastEdit = this.millis();
        }
        return c;
    }

    protected final void multitapKeyPressed(int n) {
        boolean bl = n == this.keyCode && this.millis() - this.multitapLastEdit <= this.multitapEditDuration;
        char c = '\u0000';
        if (bl && Character.isUpperCase(c = this.multitapBuffer[this.multitapBufferIndex - 1])) {
            c = Character.toLowerCase(c);
        }
        char c2 = '\u0000';
        char c3 = '\u0000';
        char c4 = '\u0000';
        block0 : switch (n) {
            case -8: {
                this.multitapDeleteChar();
                break;
            }
            case 42: {
                if (this.multitapKeySettings[0] == '*') {
                    c2 = ' ';
                    c3 = ' ';
                    c4 = '*';
                    break;
                }
                if (this.multitapKeySettings[1] == '*') {
                    bl = (c = this.multitapUpperKeyPressed(bl, c)) == '\u0000';
                    break;
                }
                c2 = '*';
                c3 = '*';
                c4 = '*';
                bl = false;
                break;
            }
            case 35: {
                if (this.multitapKeySettings[0] == '#') {
                    c2 = ' ';
                    c3 = ' ';
                    c4 = '#';
                    break;
                }
                if (this.multitapKeySettings[1] == '#') {
                    bl = (c = this.multitapUpperKeyPressed(bl, c)) == '\u0000';
                    break;
                }
                c2 = '#';
                c3 = '#';
                c4 = '#';
                bl = false;
                break;
            }
            case 48: {
                if (this.multitapKeySettings[0] == '0') {
                    c2 = ' ';
                    c3 = ' ';
                    c4 = '0';
                    break;
                }
                if (this.multitapKeySettings[1] == '0') {
                    bl = (c = this.multitapUpperKeyPressed(bl, c)) == '\u0000';
                    break;
                }
                c2 = '0';
                c3 = '0';
                c4 = '0';
                bl = false;
                break;
            }
            case 49: {
                int n2 = 0;
                if (bl && (n2 = this.multitapPunctuation.indexOf(c) + 1) == this.multitapPunctuation.length()) {
                    n2 = 0;
                }
                c = this.multitapPunctuation.charAt(n2);
                break;
            }
            case 50: {
                c2 = 'a';
                c3 = 'c';
                c4 = '2';
                break;
            }
            case 51: {
                c2 = 'd';
                c3 = 'f';
                c4 = '3';
                break;
            }
            case 52: {
                c2 = 'g';
                c3 = 'i';
                c4 = '4';
                break;
            }
            case 53: {
                c2 = 'j';
                c3 = 'l';
                c4 = '5';
                break;
            }
            case 54: {
                c2 = 'm';
                c3 = 'o';
                c4 = '6';
                break;
            }
            case 55: {
                c2 = 'p';
                c3 = 's';
                c4 = '7';
                break;
            }
            case 56: {
                c2 = 't';
                c3 = 'v';
                c4 = '8';
                break;
            }
            case 57: {
                c2 = 'w';
                c3 = 'z';
                c4 = '9';
                break;
            }
            default: {
                int n3 = this.canvas.getGameAction(n);
                switch (n3) {
                    case 2: {
                        this.multitapLastEdit = 0;
                        this.multitapBufferIndex = Math.max(0, this.multitapBufferIndex - 1);
                        break block0;
                    }
                    case 5: {
                        this.multitapLastEdit = 0;
                        this.multitapBufferIndex = Math.min(this.multitapBufferLength, this.multitapBufferIndex + 1);
                    }
                }
            }
        }
        if (c2 > '\u0000') {
            c = bl ? (char)((char)(c + 1)) : c2;
            if (c == c4 + 1) {
                c = c2;
            } else if (c > c3) {
                c = c4;
            }
        }
        if (c > '\u0000') {
            if (this.multitapIsUpperCase) {
                c = Character.toUpperCase(c);
            }
            if (bl) {
                if (this.multitapBuffer[this.multitapBufferIndex - 1] != c) {
                    this.multitapBuffer[this.multitapBufferIndex - 1] = c;
                    this.multitapLastEdit = this.millis();
                }
            } else {
                ++this.multitapBufferLength;
                if (this.multitapBufferLength == this.multitapBuffer.length) {
                    char[] cArray = this.multitapBuffer;
                    this.multitapBuffer = new char[cArray.length * 2];
                    System.arraycopy(cArray, 0, this.multitapBuffer, 0, this.multitapBufferIndex);
                    System.arraycopy(cArray, this.multitapBufferIndex, this.multitapBuffer, this.multitapBufferIndex + 1, this.multitapBufferLength - this.multitapBufferIndex);
                } else {
                    System.arraycopy(this.multitapBuffer, this.multitapBufferIndex, this.multitapBuffer, this.multitapBufferIndex + 1, this.multitapBufferLength - this.multitapBufferIndex);
                }
                this.multitapBuffer[this.multitapBufferIndex] = c;
                ++this.multitapBufferIndex;
                this.multitapLastEdit = this.millis();
            }
            this.multitapText = new String(this.multitapBuffer, 0, this.multitapBufferLength);
        }
    }

    public final int currentMemory() {
        return (int)this.runtime.freeMemory();
    }

    public final int reportedMemory() {
        return (int)this.runtime.totalMemory();
    }

    public final boolean isColor() {
        return this.display.isColor();
    }

    public final int numColors() {
        return this.display.numColors();
    }

    public final void point(int n, int n2) {
        this.canvas.point(n, n2);
    }

    public final void line(int n, int n2, int n3, int n4) {
        this.canvas.line(n, n2, n3, n4);
    }

    public final void triangle(int n, int n2, int n3, int n4, int n5, int n6) {
        this.canvas.triangle(n, n2, n3, n4, n5, n6);
    }

    public final void quad(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.canvas.quad(n, n2, n3, n4, n5, n6, n7, n8);
    }

    public final void rect(int n, int n2, int n3, int n4) {
        this.canvas.rect(n, n2, n3, n4);
    }

    public final void rectMode(int n) {
        this.canvas.rectMode(n);
    }

    public final void ellipse(int n, int n2, int n3, int n4) {
        this.canvas.ellipse(n, n2, n3, n4);
    }

    public final void ellipseMode(int n) {
        this.canvas.ellipseMode(n);
    }

    public final void curve(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.canvas.curve(n, n2, n3, n4, n5, n6, n7, n8);
    }

    public final void bezier(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.canvas.bezier(n, n2, n3, n4, n5, n6, n7, n8);
    }

    public final void strokeWeight(int n) {
        this.canvas.strokeWeight(n);
    }

    public final void beginShape(int n) {
        this.canvas.beginShape(n);
    }

    public final void endShape() {
        this.canvas.endShape();
    }

    public final void vertex(int n, int n2) {
        this.canvas.vertex(n, n2);
    }

    public final void curveVertex(int n, int n2) {
        this.canvas.curveVertex(n, n2);
    }

    public final void bezierVertex(int n, int n2, int n3, int n4, int n5, int n6) {
        this.canvas.bezierVertex(n, n2, n3, n4, n5, n6);
    }

    public final void translate(int n, int n2) {
        this.canvas.translate(n, n2);
    }

    public final void clip(int n, int n2, int n3, int n4) {
        this.canvas.clip(n, n2, n3, n4);
    }

    public final void pushMatrix() {
        this.canvas.pushMatrix();
    }

    public final void popMatrix() {
        this.canvas.popMatrix();
    }

    public final void resetMatrix() {
        this.canvas.resetMatrix();
    }

    public final void background(int n) {
        this.canvas.background(n);
    }

    public final void background(int n, int n2, int n3) {
        this.canvas.background(n, n2, n3);
    }

    public final void background(PImage pImage) {
        this.canvas.background(pImage);
    }

    public final void colorMode(int n) {
        this.canvas.colorMode(n);
    }

    public final void colorMode(int n, int n2) {
        this.colorMode(n, n2, n2, n2);
    }

    public final void colorMode(int n, int n2, int n3, int n4) {
        this.canvas.colorMode(n, n2, n3, n4);
    }

    public final void colorMode(int n, int n2, int n3, int n4, int n5) {
        this.canvas.colorMode(n, n2, n3, n4, n5);
    }

    public final int color(int n) {
        return this.canvas.color(n);
    }

    public final int color(int n, int n2) {
        return this.canvas.color(n, n2);
    }

    public final int color(int n, int n2, int n3) {
        return this.canvas.color(n, n2, n3);
    }

    public final int color(int n, int n2, int n3, int n4) {
        return this.canvas.color(n, n2, n3, n4);
    }

    public final void stroke(int n) {
        this.canvas.stroke(n);
    }

    public final void stroke(int n, int n2, int n3) {
        this.canvas.stroke(n, n2, n3);
    }

    public final void noStroke() {
        this.canvas.noStroke();
    }

    public final void fill(int n) {
        this.canvas.fill(n);
    }

    public final void fill(int n, int n2, int n3) {
        this.canvas.fill(n, n2, n3);
    }

    public final void noFill() {
        this.canvas.noFill();
    }

    public final PImage loadImage(String string) {
        try {
            Image image = Image.createImage((String)("/" + string));
            return new PImage(image);
        }
        catch (Exception exception) {
            throw new PException(exception);
        }
    }

    public final PImage loadImage(byte[] byArray) {
        return new PImage(byArray);
    }

    public final void image(PImage pImage, int n, int n2) {
        this.canvas.image(pImage, n, n2);
    }

    public final void image(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6) {
        this.canvas.image(pImage, n, n2, n3, n4, n5, n6);
    }

    public final void imageMode(int n) {
        this.canvas.imageMode(n);
    }

    public final PFont loadFont(String string, int n, int n2) {
        try {
            return new PFont(this.getClass().getResourceAsStream("/" + string), n, n2);
        }
        catch (Exception exception) {
            throw new PException(exception);
        }
    }

    public final PFont loadFont(String string, int n) {
        return this.loadFont(string, n, 0xFFFFFF);
    }

    public final PFont loadFont(String string) {
        return this.loadFont(string, 0);
    }

    public final PFont loadFont() {
        if (this.defaultFont == null) {
            this.defaultFont = new PFont(Font.getDefaultFont());
        }
        return this.defaultFont;
    }

    public final PFont loadFont(int n, int n2, int n3) {
        return new PFont(Font.getFont((int)n, (int)n2, (int)n3));
    }

    public final void textFont(PFont pFont) {
        this.canvas.textFont(pFont);
    }

    public final void textLeading(int n) {
        this.canvas.textLeading(n);
    }

    public final void textAlign(int n) {
        this.canvas.textAlign(n);
    }

    public final void text(String string, int n, int n2) {
        this.canvas.text(string, n, n2);
    }

    public final void text(String string, int n, int n2, int n3, int n4) {
        this.canvas.text(string, n, n2, n3, n4);
    }

    public final void text(String[] stringArray, int n, int n2, int n3, int n4) {
        this.canvas.text(stringArray, n, n2, n3, n4);
    }

    public final String[] textWrap(String string, int n) {
        return this.canvas.textWrap(string, n, Integer.MAX_VALUE);
    }

    public final String[] textWrap(String string, int n, int n2) {
        return this.canvas.textWrap(string, n, n2);
    }

    public final int textWidth(String string) {
        return this.canvas.textWidth(string);
    }

    public final int millis() {
        return (int)(System.currentTimeMillis() - this.startTime);
    }

    private void checkCalendar() {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
        }
        this.calendar.setTime(new Date());
    }

    public final int second() {
        this.checkCalendar();
        return this.calendar.get(13);
    }

    public final int minute() {
        this.checkCalendar();
        return this.calendar.get(12);
    }

    public final int hour() {
        this.checkCalendar();
        return this.calendar.get(11);
    }

    public final int day() {
        this.checkCalendar();
        return this.calendar.get(5);
    }

    public final int month() {
        this.checkCalendar();
        return this.calendar.get(2);
    }

    public final int year() {
        this.checkCalendar();
        return this.calendar.get(1);
    }

    public final int abs(int n) {
        return Math.abs(n);
    }

    public final int max(int n, int n2) {
        return Math.max(n, n2);
    }

    public final int min(int n, int n2) {
        return Math.min(n, n2);
    }

    public final int sq(int n) {
        return n * n;
    }

    public final int pow(int n, int n2) {
        int n3 = 1;
        for (int i = 0; i < n2; ++i) {
            n3 *= n;
        }
        return n3;
    }

    public final int constrain(int n, int n2, int n3) {
        return Math.min(Math.max(n, n2), n3);
    }

    public final int random(int n) {
        return this.random(0, n);
    }

    public final int random(int n, int n2) {
        if (this.random == null) {
            this.random = new Random();
        }
        int n3 = Math.min(n, n2);
        int n4 = Math.abs(n2 - n) + 1;
        return n3 + Math.abs(this.random.nextInt() % n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final byte[] loadBytes(String string) {
        Object object;
        try {
            object = null;
            try {
                String string2 = string;
                if (string2.length() > 32) {
                    string2 = string2.substring(0, 32);
                }
                object = RecordStore.openRecordStore((String)string2, (boolean)false);
                byte[] byArray = object.getRecord(1);
                return byArray;
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            }
            finally {
                if (object != null) {
                    object.closeRecordStore();
                }
            }
        }
        catch (Exception exception) {
            throw new PException(exception);
        }
        object = null;
        try {
            byte[] byArray;
            Object object2;
            object = this.getClass().getResourceAsStream(string);
            if (object != null) {
                object2 = new ByteArrayOutputStream();
                byte[] byArray2 = new byte[1024];
                int n = ((InputStream)object).read(byArray2);
                while (n >= 0) {
                    ((ByteArrayOutputStream)object2).write(byArray2, 0, n);
                    n = ((InputStream)object).read(byArray2);
                }
                byArray = ((ByteArrayOutputStream)object2).toByteArray();
            } else {
                byArray = new byte[]{};
            }
            object2 = byArray;
            return object2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new PException(exception);
        }
        finally {
            if (object != null) {
                try {
                    ((InputStream)object).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String[] loadStrings(String string) {
        Object[] objectArray;
        Object object;
        block26: {
            try {
                object = null;
                try {
                    String string2 = string;
                    if (string2.length() > 32) {
                        string2 = string2.substring(0, 32);
                    }
                    object = RecordStore.openRecordStore((String)string2, (boolean)false);
                    int n = object.getNumRecords();
                    String[] stringArray = new String[n];
                    for (int i = 0; i < n; ++i) {
                        stringArray[i] = new String(object.getRecord(i + 1));
                    }
                    String[] stringArray2 = stringArray;
                    return stringArray2;
                }
                catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                }
                finally {
                    if (object != null) {
                        object.closeRecordStore();
                    }
                }
            }
            catch (Exception exception) {
                throw new PException(exception);
            }
            object = new Vector();
            InputStream inputStream = null;
            try {
                inputStream = this.getClass().getResourceAsStream(string);
                if (inputStream == null) break block26;
                objectArray = new InputStreamReader(inputStream);
                int n = 0;
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = objectArray.read();
                while (true) {
                    if (n2 < 0 || n2 == 10) {
                        String string3 = stringBuffer.toString().trim();
                        if (string3.length() > 0) {
                            ++n;
                            ((Vector)object).addElement(string3);
                        }
                        stringBuffer.delete(0, Integer.MAX_VALUE);
                        if (n2 < 0) {
                            break;
                        }
                    } else {
                        stringBuffer.append((char)n2);
                    }
                    n2 = objectArray.read();
                }
            }
            catch (Exception exception) {
                throw new PException(exception);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        objectArray = new String[((Vector)object).size()];
        ((Vector)object).copyInto(objectArray);
        return objectArray;
    }

    public final void saveBytes(String string, byte[] byArray) {
        if (string.length() > 32) {
            throw new PException(new Exception("filename must be 32 characters or less"));
        }
        try {
            try {
                RecordStore.deleteRecordStore((String)string);
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                // empty catch block
            }
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            recordStore.addRecord(byArray, 0, byArray.length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            throw new PException(exception);
        }
    }

    public final void saveStrings(String string, String[] stringArray) {
        if (string.length() > 32) {
            throw new PException(new Exception("filename must be 32 characters or less"));
        }
        try {
            try {
                RecordStore.deleteRecordStore((String)string);
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                // empty catch block
            }
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                byte[] byArray = stringArray[i].getBytes();
                recordStore.addRecord(byArray, 0, byArray.length);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            throw new PException(exception);
        }
    }

    public final void print(boolean bl) {
        System.out.print(String.valueOf(bl));
    }

    public final void print(byte by) {
        System.out.print(String.valueOf(by));
    }

    public final void print(char c) {
        System.out.print(String.valueOf(c));
    }

    public final void print(int n) {
        System.out.print(String.valueOf(n));
    }

    public final void print(Object object) {
        System.out.print(String.valueOf(object));
    }

    public final void print(String string) {
        System.out.print(string);
    }

    public final void println(boolean bl) {
        System.out.println(String.valueOf(bl));
    }

    public final void println(byte by) {
        System.out.println(String.valueOf(by));
    }

    public final void println(char c) {
        System.out.println(String.valueOf(c));
    }

    public final void println(int n) {
        System.out.println(String.valueOf(n));
    }

    public final void println(Object object) {
        System.out.println(String.valueOf(object));
    }

    public final void println(String string) {
        System.out.println(string);
    }

    public final int length(boolean[] blArray) {
        return blArray.length;
    }

    public final int length(byte[] byArray) {
        return byArray.length;
    }

    public final int length(char[] cArray) {
        return cArray.length;
    }

    public final int length(int[] nArray) {
        return nArray.length;
    }

    public final int length(Object[] objectArray) {
        return objectArray.length;
    }

    public final String join(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= n - 1) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public final String join(int[] nArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(nArray[i]);
            if (i >= n - 1) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public final String join(int[] nArray, String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(this.nf(nArray[i], n));
            if (i >= n2 - 1) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public final String nf(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = Integer.toString(n).length(); i < n2; ++i) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n);
        return stringBuffer.toString();
    }

    public final String nfp(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n < 0) {
            stringBuffer.append("-");
        } else {
            stringBuffer.append("+");
        }
        stringBuffer.append(this.nf(n, n2));
        return stringBuffer.toString();
    }

    public final String nfs(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n < 0) {
            stringBuffer.append("-");
        } else {
            stringBuffer.append(" ");
        }
        stringBuffer.append(this.nf(n, n2));
        return stringBuffer.toString();
    }

    public final String[] split(String string) {
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = string.length();
        block3: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    bl = true;
                    continue block3;
                }
                default: {
                    if (bl) {
                        vector.addElement(stringBuffer.toString());
                        stringBuffer.delete(0, stringBuffer.length());
                        bl = false;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        if (stringBuffer.length() > 0) {
            vector.addElement(stringBuffer.toString());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public final String[] split(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = string.indexOf(string2, n);
        int n3 = string2.length();
        while (n2 >= 0) {
            vector.addElement(string.substring(n, n2));
            n = n2 + n3;
            n2 = string.indexOf(string2, n);
        }
        if (n < string.length()) {
            vector.addElement(string.substring(n));
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public final String trim(String string) {
        return string.trim();
    }

    public final String[] append(String[] stringArray, String string) {
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        stringArray = new String[n + 1];
        System.arraycopy(stringArray2, 0, stringArray, 0, n);
        stringArray[n] = string;
        return stringArray;
    }

    public final boolean[] append(boolean[] blArray, boolean bl) {
        boolean[] blArray2 = blArray;
        int n = blArray2.length;
        blArray = new boolean[n + 1];
        System.arraycopy(blArray2, 0, blArray, 0, n);
        blArray[n] = bl;
        return blArray;
    }

    public final byte[] append(byte[] byArray, byte by) {
        byte[] byArray2 = byArray;
        int n = byArray2.length;
        byArray = new byte[n + 1];
        System.arraycopy(byArray2, 0, byArray, 0, n);
        byArray[n] = by;
        return byArray;
    }

    public final char[] append(char[] cArray, char c) {
        char[] cArray2 = cArray;
        int n = cArray2.length;
        cArray = new char[n + 1];
        System.arraycopy(cArray2, 0, cArray, 0, n);
        cArray[n] = c;
        return cArray;
    }

    public final int[] append(int[] nArray, int n) {
        int[] nArray2 = nArray;
        int n2 = nArray2.length;
        nArray = new int[n2 + 1];
        System.arraycopy(nArray2, 0, nArray, 0, n2);
        nArray[n2] = n;
        return nArray;
    }

    public final void arraycopy(Object object, int n, Object object2, int n2, int n3) {
        System.arraycopy(object, n, object2, n2, n3);
    }

    public final String[] concat(String[] stringArray, String[] stringArray2) {
        int n = stringArray.length;
        int n2 = stringArray2.length;
        String[] stringArray3 = new String[n + n2];
        System.arraycopy(stringArray, 0, stringArray3, 0, n);
        System.arraycopy(stringArray2, 0, stringArray3, n, n2);
        return stringArray3;
    }

    public final boolean[] concat(boolean[] blArray, boolean[] blArray2) {
        int n = blArray.length;
        int n2 = blArray2.length;
        boolean[] blArray3 = new boolean[n + n2];
        System.arraycopy(blArray, 0, blArray3, 0, n);
        System.arraycopy(blArray2, 0, blArray3, n, n2);
        return blArray3;
    }

    public final byte[] concat(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        int n2 = byArray2.length;
        byte[] byArray3 = new byte[n + n2];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        System.arraycopy(byArray2, 0, byArray3, n, n2);
        return byArray3;
    }

    public final char[] concat(char[] cArray, char[] cArray2) {
        int n = cArray.length;
        int n2 = cArray2.length;
        char[] cArray3 = new char[n + n2];
        System.arraycopy(cArray, 0, cArray3, 0, n);
        System.arraycopy(cArray2, 0, cArray3, n, n2);
        return cArray3;
    }

    public final int[] concat(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        int n2 = nArray2.length;
        int[] nArray3 = new int[n + n2];
        System.arraycopy(nArray, 0, nArray3, 0, n);
        System.arraycopy(nArray2, 0, nArray3, n, n2);
        return nArray3;
    }

    public final String[] contract(String[] stringArray, int n) {
        int n2 = stringArray.length;
        if (n2 > n) {
            String[] stringArray2 = stringArray;
            stringArray = new String[n];
            System.arraycopy(stringArray2, 0, stringArray, 0, n);
        }
        return stringArray;
    }

    public final String[] expand(String[] stringArray) {
        return this.expand(stringArray, stringArray.length * 2);
    }

    public final String[] expand(String[] stringArray, int n) {
        int n2 = stringArray.length;
        if (n2 < n) {
            String[] stringArray2 = stringArray;
            stringArray = new String[n];
            System.arraycopy(stringArray2, 0, stringArray, 0, n2);
        }
        return stringArray;
    }

    public final String[] reverse(String[] stringArray) {
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = n - 1; i >= 0; --i) {
            stringArray2[i] = stringArray[n - i - 1];
        }
        return stringArray2;
    }

    public final String[] shorten(String[] stringArray) {
        String[] stringArray2 = stringArray;
        int n = stringArray2.length - 1;
        stringArray = new String[n];
        System.arraycopy(stringArray2, 0, stringArray, 0, n);
        return stringArray;
    }

    public final String[] slice(String[] stringArray, int n) {
        return this.slice(stringArray, n, stringArray.length - n);
    }

    public final String[] slice(String[] stringArray, int n, int n2) {
        String[] stringArray2 = new String[n2];
        System.arraycopy(stringArray, n, stringArray2, 0, n2);
        return stringArray2;
    }

    public final String[] splice(String[] stringArray, String string, int n) {
        int n2 = stringArray.length;
        String[] stringArray2 = new String[n2 + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        stringArray2[n] = string;
        System.arraycopy(stringArray, n, stringArray2, n + 1, n2 - n);
        return stringArray2;
    }

    public final String[] splice(String[] stringArray, String[] stringArray2, int n) {
        int n2 = stringArray.length;
        int n3 = stringArray2.length;
        String[] stringArray3 = new String[n2 + n3];
        System.arraycopy(stringArray, 0, stringArray3, 0, n);
        System.arraycopy(stringArray2, 0, stringArray3, n, n3);
        System.arraycopy(stringArray, n, stringArray3, n + n3, n2 - n);
        return stringArray3;
    }

    public static final char toChar(boolean bl) {
        return bl ? (char)'t' : 'f';
    }

    public static final char toChar(byte by) {
        return (char)(by & 0xFF);
    }

    public static final char toChar(int n) {
        return (char)n;
    }

    public static final char[] toChar(String string) {
        return string.toCharArray();
    }

    public static final char[] toChar(boolean[] blArray) {
        char[] cArray = new char[blArray.length];
        for (int i = blArray.length - 1; i >= 0; --i) {
            cArray[i] = blArray[i] ? 116 : 102;
        }
        return cArray;
    }

    public static final char[] toChar(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i = byArray.length - 1; i >= 0; --i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        return cArray;
    }

    public static final char[] toChar(int[] nArray) {
        char[] cArray = new char[nArray.length];
        for (int i = nArray.length - 1; i >= 0; --i) {
            cArray[i] = (char)nArray[i];
        }
        return cArray;
    }

    public static final char[][] toChar(String[] stringArray) {
        char[][] cArrayArray = new char[stringArray.length][];
        for (int i = stringArray.length - 1; i >= 0; --i) {
            cArrayArray[i] = stringArray[i].toCharArray();
        }
        return cArrayArray;
    }

    public static final int toInt(boolean bl) {
        return bl ? 1 : 0;
    }

    public static final int toInt(byte by) {
        return by & 0xFF;
    }

    public static final int toInt(char c) {
        return c;
    }

    public static final int toInt(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public static final int[] toInt(boolean[] blArray) {
        int[] nArray = new int[blArray.length];
        for (int i = blArray.length - 1; i >= 0; --i) {
            nArray[i] = blArray[i] ? 116 : 102;
        }
        return nArray;
    }

    public static final int[] toInt(byte[] byArray) {
        int[] nArray = new int[byArray.length];
        for (int i = byArray.length - 1; i >= 0; --i) {
            nArray[i] = byArray[i] & 0xFF;
        }
        return nArray;
    }

    public static final int[] toInt(char[] cArray) {
        int[] nArray = new int[cArray.length];
        for (int i = cArray.length - 1; i >= 0; --i) {
            nArray[i] = cArray[i];
        }
        return nArray;
    }

    public static final int[] toInt(String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        for (int i = stringArray.length - 1; i >= 0; --i) {
            try {
                nArray[i] = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return nArray;
    }

    public static final String str(boolean bl) {
        return String.valueOf(bl);
    }

    public static final String str(byte by) {
        return String.valueOf(by);
    }

    public static final String str(char c) {
        return String.valueOf(c);
    }

    public static final String str(int n) {
        return String.valueOf(n);
    }

    public static final String[] str(boolean[] blArray) {
        String[] stringArray = new String[blArray.length];
        for (int i = blArray.length - 1; i >= 0; --i) {
            stringArray[i] = String.valueOf(blArray[i]);
        }
        return stringArray;
    }

    public static final String[] str(byte[] byArray) {
        String[] stringArray = new String[byArray.length];
        for (int i = byArray.length - 1; i >= 0; --i) {
            stringArray[i] = String.valueOf(byArray[i]);
        }
        return stringArray;
    }

    public static final String[] str(char[] cArray) {
        String[] stringArray = new String[cArray.length];
        for (int i = cArray.length - 1; i >= 0; --i) {
            stringArray[i] = String.valueOf(cArray[i]);
        }
        return stringArray;
    }

    public static final String[] str(int[] nArray) {
        String[] stringArray = new String[nArray.length];
        for (int i = nArray.length - 1; i >= 0; --i) {
            stringArray[i] = String.valueOf(nArray[i]);
        }
        return stringArray;
    }

    public final int mul(int n, int n2) {
        return n * n2 >> 8;
    }

    public final int div(int n, int n2) {
        return (n << 8) / n2;
    }

    public final int itofp(int n) {
        return n << 8;
    }

    public final int fptoi(int n) {
        if (n < 0) {
            n += 255;
        }
        return n >> 8;
    }

    public final int sqrt(int n) {
        int n2;
        int n3 = n;
        int n4 = 0;
        while ((n2 = n3 >> 8) != 0) {
            n4 = (n3 + n / n2) / 2;
            int n5 = n3 > n4 ? n3 - n4 : n4 - n3;
            n3 = n4;
            if (n5 > 256) continue;
        }
        return n4;
    }

    public final int dist(int n, int n2, int n3, int n4) {
        int n5 = n3 - n;
        int n6 = n4 - n2;
        return this.sqrt(n5 * n5 + n6 * n6 << 8);
    }

    public final int dist_fp(int n, int n2, int n3, int n4) {
        int n5 = n3 - n;
        int n6 = n4 - n2;
        return this.sqrt((n5 * n5 >> 8) + (n6 * n6 >> 8));
    }

    public final int floor(int n) {
        return n >> 8 << 8;
    }

    public final int ceil(int n) {
        return n + 256 - 1 >> 8 << 8;
    }

    public final int round(int n) {
        return n + 128 >> 8 << 8;
    }

    public final int radians(int n) {
        return n * 804 / 46080;
    }

    public final int sin(int n) {
        int n2 = n * 180 / 804 % 360;
        if (n2 < 0) {
            n2 += 360;
        }
        return sin[n2];
    }

    public final int cos(int n) {
        int n2 = (n * 180 / 804 + 90) % 360;
        if (n2 < 0) {
            n2 += 360;
        }
        return sin[n2];
    }

    public final int atan(int n) {
        int n2 = n <= 256 ? this.div(n, 256 + this.mul(71, this.mul(n, n))) : 402 - this.div(n, this.mul(n, n) + 71);
        return n2;
    }

    public final int atan2(int n, int n2) {
        int n3 = n == 0 && n2 == 0 ? 0 : (n2 > 0 ? this.atan(this.div(n, n2)) : (n2 < 0 ? (n < 0 ? -(804 - this.atan(this.div(-n, -n2))) : 804 - this.atan(this.div(n, -n2))) : (n < 0 ? -402 : 402)));
        return n3;
    }

    private static void make_crc_table() {
        crc_table = new int[256];
        for (int i = 0; i < 256; ++i) {
            long l = i;
            for (int j = 0; j < 8; ++j) {
                if ((l & 1L) != 0L) {
                    l = 0xEDB88320L ^ l >> 1;
                    continue;
                }
                l >>= 1;
            }
            PMIDlet.crc_table[i] = (int)l;
        }
    }

    private static int update_crc(long l, byte[] byArray, int n, int n2) {
        long l2 = l;
        if (crc_table == null) {
            PMIDlet.make_crc_table();
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            l2 = (long)crc_table[(int)((l2 ^ (long)byArray[i]) & 0xFFL)] & 0xFFFFFFFFL ^ l2 >> 8;
        }
        return (int)l2;
    }

    public static int crc(byte[] byArray, int n, int n2) {
        return ~PMIDlet.update_crc(0xFFFFFFFFL, byArray, n, n2);
    }

    public class PList
    extends PComponent {
        public PFont font;
        public PScrollBar scrollbar;
        protected Vector items;
        public int selected;
        protected int first;
        protected boolean marqueeScrolling;
        protected int marqueeStart;
        protected int marqueeWidth;
        protected int marqueeOffset;

        public PList() {
            this.acceptsFocus = true;
            this.borderWidth = 1;
            this.highlightWidth = 1;
            this.font = PMIDlet.this.loadFont();
            this.items = new Vector();
        }

        public boolean acceptFocus() {
            this.focused = true;
            this.resetMarquee();
            if (this.scrollbar != null) {
                this.scrollbar.focused = true;
            }
            return true;
        }

        public void releaseFocus() {
            this.focused = false;
            if (this.scrollbar != null) {
                this.scrollbar.focused = false;
            }
        }

        public void add(Object object) {
            this.items.addElement(object);
        }

        public void add(Object[] objectArray) {
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                this.items.addElement(objectArray[i]);
            }
        }

        public Object get(int n) {
            return this.items.elementAt(n);
        }

        public void initialize() {
            if (this.scrollbar != null) {
                this.scrollbar.setRange(0, this.items.size() - 1, this.contentHeight / this.getRowHeight());
                this.scrollbar.initialize();
            }
        }

        protected void resetMarquee() {
            if (this.items.size() > 0) {
                Object e = this.items.elementAt(this.selected);
                this.marqueeWidth = this.font.stringWidth(e.toString());
                this.marqueeOffset = 0;
                if (this.marqueeWidth > this.contentWidth - 2) {
                    this.marqueeScrolling = true;
                    this.marqueeStart = PMIDlet.this.millis();
                } else {
                    this.marqueeScrolling = false;
                }
            }
        }

        protected int getRowHeight() {
            return this.font.height + 2;
        }

        public boolean keyPressed() {
            boolean bl = false;
            int n = this.selected;
            switch (PMIDlet.this.keyCode) {
                case 1: {
                    this.selected = PMIDlet.this.max(0, this.selected - 1);
                    if (this.selected >= this.first) break;
                    this.first = PMIDlet.this.max(0, this.selected);
                    break;
                }
                case 6: {
                    this.selected = PMIDlet.this.min(this.items.size() - 1, this.selected + 1);
                    int n2 = this.contentHeight / this.getRowHeight();
                    if (this.selected < this.first + n2) break;
                    this.first = PMIDlet.this.min(this.selected - n2 + 1, this.items.size() - n2);
                    break;
                }
                case 8: {
                    this.pressed = true;
                    bl = true;
                }
            }
            if (this.selected != n) {
                this.resetMarquee();
                if (this.scrollbar != null) {
                    this.scrollbar.setValue(this.first);
                }
                bl = true;
            }
            return bl;
        }

        public boolean keyReleased() {
            boolean bl = false;
            this.pressed = false;
            if (PMIDlet.this.keyCode == 8) {
                PMIDlet.this.enqueueLibraryEvent(this, 0, this.items.elementAt(this.selected));
                bl = true;
            }
            return bl;
        }

        protected void drawBefore() {
            int n = this.pressedFgColor;
            this.pressedFgColor = this.focusedFgColor;
            super.drawBefore();
            this.pressedFgColor = n;
        }

        protected void drawContent() {
            PMIDlet.this.textFont(this.font);
            PMIDlet.this.textAlign(2);
            PMIDlet.this.fill(0);
            int n = this.getRowHeight();
            int n2 = this.contentHeight / n;
            if (this.contentHeight % n > 0) {
                ++n2;
            }
            int n3 = this.contentY;
            int n4 = this.contentY + this.contentHeight;
            int n5 = PMIDlet.this.min(this.items.size(), this.first + n2);
            for (int i = this.first; i < n5; ++i) {
                this.drawItem(this.items.elementAt(i), this.contentX, n3, this.contentWidth, PMIDlet.this.min(n, n4 - n3), i == this.selected);
                n3 += n;
            }
            if (this.scrollbar != null) {
                this.scrollbar.draw();
            }
        }

        protected void drawItem(Object object, int n, int n2, int n3, int n4, boolean bl) {
            if (bl) {
                PMIDlet.this.noStroke();
                PMIDlet.this.fill(this.pressed ? this.pressedFgColor : (this.focused ? this.focusedHighlightColor : this.unfocusedHighlightColor));
                PMIDlet.this.rect(n, n2, n3, n4);
                PMIDlet.this.fill(0);
            }
            PMIDlet.this.pushMatrix();
            PMIDlet.this.clip(n + 1, n2 + 1, n3 - 2, n4 - 2);
            if (bl && this.focused && this.marqueeScrolling) {
                int n5 = PMIDlet.this.millis();
                int n6 = this.marqueeWidth - this.contentWidth + 2;
                if (this.marqueeOffset == n6) {
                    if (n5 - this.marqueeStart > 750) {
                        this.marqueeStart = n5;
                        this.marqueeOffset = 0;
                    }
                } else if (n5 - this.marqueeStart > 750) {
                    this.marqueeOffset = (n5 - this.marqueeStart - 750) / 20;
                    if (this.marqueeOffset >= n6) {
                        this.marqueeOffset = n6;
                        this.marqueeStart = n5;
                    }
                }
                PMIDlet.this.text(object.toString(), n + 1 - this.marqueeOffset, n2 + 1 + this.font.baseline);
            } else {
                PMIDlet.this.text(object.toString(), n + 1, n2 + 1 + this.font.baseline);
            }
            PMIDlet.this.popMatrix();
        }
    }

    public class PScrollBar
    extends PComponent {
        protected int min;
        protected int max;
        protected int pageSize;
        protected int value;
        protected int grabberHeight;

        public PScrollBar() {
            this.highlightWidth = 1;
        }

        public void setRange(int n, int n2, int n3) {
            this.min = n;
            this.max = n2;
            this.pageSize = n3;
            this.value = n;
        }

        public void setValue(int n) {
            this.value = n;
        }

        public void initialize() {
            int n = 0;
            if (this.pageSize == 0) {
                this.pageSize = Integer.MAX_VALUE;
            }
            if (this.pageSize > 0) {
                n = (this.max - this.min + 1) / this.pageSize;
                this.grabberHeight = this.contentHeight / n;
                if ((this.max - this.min + 1) % this.pageSize != 0) {
                    this.grabberHeight += (this.contentHeight / ++n - this.grabberHeight) / 2;
                }
            }
            this.grabberHeight = PMIDlet.this.max(4, this.grabberHeight);
        }

        protected void drawContent() {
            if (this.max >= this.min) {
                PMIDlet.this.noStroke();
                PMIDlet.this.fill(this.focused ? this.focusedHighlightColor : this.unfocusedHighlightColor);
                PMIDlet.this.rect(this.contentX, this.contentY, this.contentWidth, this.contentHeight);
                PMIDlet.this.fill(this.focused ? this.focusedBorderColor : this.unfocusedBorderColor);
                if (this.value + this.pageSize - 1 >= this.max) {
                    PMIDlet.this.rect(this.contentX, this.contentY + this.contentHeight - this.grabberHeight, this.contentWidth, this.grabberHeight);
                } else {
                    PMIDlet.this.rect(this.contentX, this.contentY + (this.value - this.min) * this.contentHeight / (this.max - this.min + 1), this.contentWidth, this.grabberHeight);
                }
            }
        }
    }

    public class PLabel
    extends PComponent {
        public PFont font;
        public int fontColor;
        public int leading;
        public int align;
        public String text;
        public String[] lines;

        public PLabel(String string) {
            this.unfocusedFgColor = 0;
            this.font = PMIDlet.this.loadFont();
            this.fontColor = -16777216;
            this.leading = this.font.height;
            this.align = 2;
            this.text = string;
        }

        protected void calculateContentBounds(int n, int n2, int n3, int n4) {
            PMIDlet.this.textFont(this.font);
            PMIDlet.this.textLeading(this.leading);
            int n5 = PMIDlet.this.textWidth(this.text);
            if (n5 > n3 || this.text.indexOf(10) >= 0) {
                this.lines = PMIDlet.this.textWrap(this.text, n3);
                this.text = null;
                this.setBounds(n, n2, n3, PMIDlet.this.length(this.lines) * this.leading);
            } else {
                this.setBounds(n, n2, n5, this.leading);
            }
        }

        protected void drawContent() {
            PMIDlet.this.fill(this.fontColor);
            PMIDlet.this.textFont(this.font);
            PMIDlet.this.textAlign(this.align);
            PMIDlet.this.textLeading(this.leading);
            if (this.text == null && this.lines != null) {
                PMIDlet.this.text(this.lines, this.contentX, this.contentY, this.contentWidth, this.contentHeight);
            } else if (this.text != null) {
                PMIDlet.this.text(this.text, this.contentX, this.contentY, this.contentWidth, this.contentHeight);
            }
        }
    }

    public class PImageLabel
    extends PComponent {
        protected PImage img;

        public PImageLabel(PImage pImage) {
            this.unfocusedFgColor = 0;
            this.img = pImage;
        }

        protected void calculateContentBounds(int n, int n2, int n3, int n4) {
            if (this.img != null) {
                n3 = PMIDlet.this.min(n3, this.img.width);
                n4 = PMIDlet.this.min(n4, this.img.height);
                this.setBounds(n, n2, n3, n4);
            } else {
                this.setBounds(n, n2, PMIDlet.this.min(n3, 10), PMIDlet.this.min(n4, 10));
            }
        }

        protected void drawContent() {
            if (this.img != null) {
                PMIDlet.this.pushMatrix();
                PMIDlet.this.clip(this.contentX, this.contentY, this.contentWidth, this.contentHeight);
                PMIDlet.this.image(this.img, this.contentX, this.contentY);
                PMIDlet.this.popMatrix();
            } else {
                PMIDlet.this.stroke(this.focused ? this.focusedBorderColor : this.unfocusedBorderColor);
                PMIDlet.this.noFill();
                PMIDlet.this.rect(this.contentX, this.contentY, this.contentWidth - 1, this.contentHeight - 1);
                PMIDlet.this.line(this.contentX, this.contentY, this.contentX + this.contentWidth - 1, this.contentY + this.contentHeight - 1);
                PMIDlet.this.line(this.contentX + this.contentWidth - 1, this.contentY, this.contentX, this.contentY + this.contentHeight - 1);
            }
        }
    }

    public class PButton
    extends PComponent {
        public PFont font;
        public int fontColor;
        public String label;

        public PButton(String string) {
            this.highlightWidth = 1;
            this.borderWidth = 1;
            this.padding = 0x2040204;
            this.acceptsFocus = true;
            this.focusedFgColor = -146327;
            this.font = PMIDlet.this.loadFont();
            this.fontColor = -16777216;
            this.label = string;
        }

        protected void calculateContentBounds(int n, int n2, int n3, int n4) {
            n3 = PMIDlet.this.min(n3, this.font.stringWidth(this.label));
            n4 = PMIDlet.this.min(n4, this.font.height);
            this.setBounds(n, n2, n3, n4);
        }

        protected void drawContent() {
            PMIDlet.this.textFont(this.font);
            PMIDlet.this.fill(this.fontColor);
            PMIDlet.this.textAlign(0);
            PMIDlet.this.text(this.label, this.contentX + (this.contentWidth >> 1), this.contentY + this.font.baseline);
        }

        public boolean keyPressed() {
            boolean bl = false;
            if (PMIDlet.this.keyCode == 8) {
                this.pressed = true;
                bl = true;
            }
            return bl;
        }

        public boolean keyReleased() {
            boolean bl = false;
            this.pressed = false;
            if (PMIDlet.this.keyCode == 8) {
                PMIDlet.this.enqueueLibraryEvent(this, 0, this.label);
                bl = true;
            }
            return bl;
        }
    }

    public class PCheckBox
    extends PComponent {
        public boolean checked;

        public PCheckBox(boolean bl) {
            this.highlightWidth = 1;
            this.borderWidth = 1;
            this.acceptsFocus = true;
            this.checked = bl;
        }

        protected void calculateContentBounds(int n, int n2, int n3, int n4) {
            PFont pFont = PMIDlet.this.loadFont();
            int n5 = pFont.height;
            n3 = PMIDlet.this.min(n3, n5);
            n4 = PMIDlet.this.min(n4, n5);
            this.setBounds(n, n2, n3, n4);
        }

        protected void drawContent() {
            if (this.checked) {
                PMIDlet.this.stroke(this.focused ? this.focusedBorderColor : this.unfocusedBorderColor);
                int n = this.contentX + this.contentWidth - 1;
                int n2 = this.contentY + this.contentHeight - 1;
                PMIDlet.this.line(this.contentX, this.contentY, n, n2);
                PMIDlet.this.line(n, this.contentY, this.contentX, n2);
            }
        }

        public boolean keyPressed() {
            boolean bl = false;
            if (PMIDlet.this.keyCode == 8) {
                this.pressed = true;
                this.checked = !this.checked;
                PMIDlet.this.enqueueLibraryEvent(this, 0, null);
                bl = true;
            }
            return bl;
        }

        public boolean keyReleased() {
            this.pressed = false;
            return false;
        }
    }

    public class PRadioButton
    extends PComponent {
        public int id;
        public boolean selected;
        protected PRadioButtonGroup group;

        public PRadioButton(boolean bl, PRadioButtonGroup pRadioButtonGroup) {
            this.highlightWidth = 1;
            this.borderWidth = 1;
            this.padding = 0x2020202;
            this.acceptsFocus = true;
            this.selected = bl;
            this.group = pRadioButtonGroup;
            pRadioButtonGroup.addRadioButton(this);
        }

        protected void calculateContentBounds(int n, int n2, int n3, int n4) {
            PFont pFont = PMIDlet.this.loadFont();
            int n5 = pFont.height;
            n3 = PMIDlet.this.min(n3, n5);
            n4 = PMIDlet.this.min(n4, n5);
            this.setBounds(n, n2, n3, n4);
        }

        public void initialize() {
        }

        protected void drawBefore() {
            int n;
            PMIDlet.this.noStroke();
            if (this.bgColor != 0) {
                PMIDlet.this.fill(this.bgColor);
                PMIDlet.this.rect(this.x, this.y, this.width, this.height);
            }
            PMIDlet.this.ellipseMode(2);
            if (this.highlightWidth > 0) {
                int n2 = n = this.focused ? this.focusedHighlightColor : this.unfocusedHighlightColor;
                if (n != 0) {
                    PMIDlet.this.fill(n);
                    PMIDlet.this.ellipse(this.x, this.y, this.width, this.height);
                }
            }
            if (this.borderWidth > 0) {
                int n3 = n = this.focused ? this.focusedBorderColor : this.unfocusedBorderColor;
                if (n != 0) {
                    PMIDlet.this.fill(n);
                    PMIDlet.this.ellipse(this.x + this.highlightWidth, this.y + this.highlightWidth, this.width - (this.highlightWidth << 1), this.height - (this.highlightWidth << 1));
                }
            }
            int n4 = this.pressed ? this.pressedFgColor : (n = this.focused ? this.focusedFgColor : this.unfocusedFgColor);
            if (n != 0) {
                PMIDlet.this.fill(n);
                PMIDlet.this.ellipse(this.x + this.highlightWidth + this.borderWidth, this.y + this.highlightWidth + this.borderWidth, this.width - (this.highlightWidth + this.borderWidth << 1), this.height - (this.highlightWidth + this.borderWidth << 1));
            }
        }

        protected void drawContent() {
            if (this.selected) {
                PMIDlet.this.noStroke();
                PMIDlet.this.fill(this.focused ? this.focusedBorderColor : this.unfocusedBorderColor);
                PMIDlet.this.ellipse(this.contentX, this.contentY, this.contentWidth, this.contentHeight);
            }
        }

        protected void drawAfter() {
        }

        public boolean keyPressed() {
            boolean bl = false;
            if (PMIDlet.this.keyCode == 8) {
                if (!this.selected) {
                    PMIDlet.this.enqueueLibraryEvent(this.group, 0, null);
                }
                this.pressed = true;
                this.group.clear();
                this.selected = true;
                bl = true;
            }
            return bl;
        }

        public boolean keyReleased() {
            this.pressed = false;
            return false;
        }
    }

    public class PRadioButtonGroup {
        protected Vector buttons = new Vector();

        public void addRadioButton(PRadioButton pRadioButton) {
            if (!this.buttons.contains(pRadioButton)) {
                this.buttons.addElement(pRadioButton);
            }
        }

        public void removeRadioButton(PRadioButton pRadioButton) {
            this.buttons.removeElement(pRadioButton);
        }

        public void clear() {
            Enumeration enumeration = this.buttons.elements();
            while (enumeration.hasMoreElements()) {
                PRadioButton pRadioButton = (PRadioButton)enumeration.nextElement();
                pRadioButton.selected = false;
            }
        }

        public PRadioButton getSelected() {
            Enumeration enumeration = this.buttons.elements();
            PRadioButton pRadioButton = null;
            while (enumeration.hasMoreElements()) {
                pRadioButton = (PRadioButton)enumeration.nextElement();
                if (!pRadioButton.selected) continue;
            }
            if (pRadioButton != null && !pRadioButton.selected) {
                pRadioButton = null;
            }
            return pRadioButton;
        }
    }

    public class PContainer
    extends PComponent {
        public static final int HEIGHT_UNBOUNDED = Integer.MAX_VALUE;
        protected Vector children;
        protected int focusedChild;
        public boolean scrolling;
        public int scrollY;
        public int scrollHeight;
        public PScrollBar scrollbar;

        public PContainer() {
            this.acceptsFocus = true;
            this.children = new Vector();
        }

        public void add(PComponent pComponent) {
            this.children.addElement(pComponent);
        }

        public void remove(PComponent pComponent) {
            this.children.removeElement(pComponent);
        }

        public void initialize() {
            this.focusedChild = -1;
            this.scrollY = 0;
            this.scrollHeight = 0;
            int n = this.children.size();
            for (int i = 0; i < n; ++i) {
                PComponent pComponent = (PComponent)this.children.elementAt(i);
                pComponent.initialize();
                this.scrollHeight = Math.max(this.scrollHeight, pComponent.y + pComponent.height);
                if (this.focusedChild >= 0 || !pComponent.acceptFocus()) continue;
                this.focusedChild = i;
            }
            this.scrollHeight -= this.contentY;
            if (this.scrollbar != null) {
                this.scrollbar.setRange(0, this.scrollHeight - 1, this.contentHeight);
                this.scrollbar.initialize();
            }
        }

        public boolean acceptFocus() {
            super.acceptFocus();
            if (this.focused && this.children.size() > 0 && this.focusedChild >= 0) {
                PComponent pComponent = (PComponent)this.children.elementAt(this.focusedChild);
                pComponent.acceptFocus();
            }
            return this.focused;
        }

        public void releaseFocus() {
            super.releaseFocus();
            if (this.children.size() > 0 && this.focusedChild >= 0) {
                PComponent pComponent = (PComponent)this.children.elementAt(this.focusedChild);
                pComponent.releaseFocus();
            }
        }

        public boolean keyPressed() {
            PComponent pComponent;
            boolean bl = false;
            if (this.children.size() > 0 && this.focusedChild >= 0) {
                pComponent = (PComponent)this.children.elementAt(this.focusedChild);
                bl = pComponent.keyPressed();
            }
            if (!bl) {
                int n = 0;
                int n2 = this.children.size();
                switch (PMIDlet.this.keyCode) {
                    case 1: {
                        n = -1;
                        n2 = -1;
                        break;
                    }
                    case 6: {
                        n = 1;
                    }
                }
                if (n != 0) {
                    int n3 = this.scrollY;
                    boolean bl2 = true;
                    if (this.scrolling && this.scrollHeight > this.contentHeight) {
                        if (this.focusedChild >= 0) {
                            pComponent = (PComponent)this.children.elementAt(this.focusedChild);
                            if (n > 0) {
                                if (pComponent.y + pComponent.height > this.contentY + this.scrollY + this.contentHeight) {
                                    this.scrollY = Math.min(this.scrollHeight - this.contentHeight, this.scrollY + this.contentHeight - 4);
                                }
                            } else if (pComponent.y < this.contentY + this.scrollY) {
                                this.scrollY = Math.max(0, this.scrollY - this.contentHeight + 4);
                            }
                        } else {
                            this.scrollY = n > 0 ? Math.min(this.scrollHeight - this.contentHeight, this.scrollY + this.contentHeight - 4) : Math.max(0, this.scrollY - this.contentHeight + 4);
                        }
                        if (this.scrollY != n3) {
                            bl2 = false;
                            bl = true;
                        }
                    }
                    if (bl2 && this.focusedChild >= 0) {
                        for (int i = this.focusedChild + n; i != n2; i += n) {
                            pComponent = (PComponent)this.children.elementAt(i);
                            if (!pComponent.acceptFocus()) continue;
                            if (this.scrolling && this.scrollHeight > this.contentHeight) {
                                if (n > 0) {
                                    if (pComponent.y + pComponent.height > this.contentY + this.scrollY + this.contentHeight) {
                                        this.scrollY = Math.min(this.scrollHeight - this.contentHeight, Math.min(pComponent.y, this.scrollY + this.contentHeight - 4));
                                    }
                                } else if (pComponent.y < this.contentY + this.scrollY) {
                                    this.scrollY = Math.max(0, Math.max(pComponent.y + pComponent.height - this.contentHeight, this.scrollY - this.contentHeight + 4));
                                }
                            }
                            pComponent = (PComponent)this.children.elementAt(this.focusedChild);
                            pComponent.releaseFocus();
                            this.focusedChild = i;
                            bl = true;
                            break;
                        }
                        if (!bl && this.scrolling && this.scrollHeight > this.contentHeight) {
                            this.scrollY = n > 0 ? Math.min(this.scrollHeight - this.contentHeight, this.scrollY + this.contentHeight - 4) : Math.max(0, this.scrollY - this.contentHeight + 4);
                            boolean bl3 = bl = n3 != this.scrollY;
                        }
                    }
                    if (this.scrollY != n3 && this.scrollbar != null) {
                        this.scrollbar.setValue(this.scrollY);
                    }
                }
            }
            return bl;
        }

        public boolean keyReleased() {
            boolean bl = false;
            if (this.children.size() > 0 && this.focusedChild >= 0) {
                PComponent pComponent = (PComponent)this.children.elementAt(this.focusedChild);
                bl = pComponent.keyReleased();
            }
            return bl;
        }

        protected void drawContent() {
            if (this.scrolling && this.scrollHeight > this.contentHeight) {
                PMIDlet.this.pushMatrix();
                PMIDlet.this.clip(this.contentX, this.contentY, this.contentWidth, this.contentHeight);
                PMIDlet.this.translate(0, -this.scrollY);
            }
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                PComponent pComponent = (PComponent)enumeration.nextElement();
                if (this.scrolling && !pComponent.intersects(this.contentX, this.contentY + this.scrollY, this.contentWidth, this.contentHeight)) continue;
                pComponent.draw();
            }
            if (this.scrolling && this.scrollHeight > this.contentHeight) {
                PMIDlet.this.popMatrix();
                if (this.scrollbar != null) {
                    this.scrollbar.draw();
                }
            }
        }
    }

    public class PComponent {
        public static final int DEFAULT_BG_COLOR = -1;
        public static final int DEFAULT_FG_FOCUSED_COLOR = -1;
        public static final int DEFAULT_FG_UNFOCUSED_COLOR = -657931;
        public static final int DEFAULT_FG_PRESSED_COLOR = -3827407;
        public static final int DEFAULT_BORDER_FOCUSED_COLOR = -5801984;
        public static final int DEFAULT_BORDER_UNFOCUSED_COLOR = -10066330;
        public static final int DEFAULT_HIGHLIGHT_FOCUSED_COLOR = -146327;
        public static final int DEFAULT_HIGHLIGHT_UNFOCUSED_COLOR = -3026479;
        public int x;
        public int y;
        public int width;
        public int height;
        public int contentX;
        public int contentY;
        public int contentWidth;
        public int contentHeight;
        public int margin;
        public int padding;
        public boolean acceptsFocus;
        public boolean focused;
        public boolean pressed;
        public int bgColor = -1;
        public int pressedFgColor = -3827407;
        public int focusedFgColor = -1;
        public int unfocusedFgColor = -657931;
        public int highlightWidth;
        public int focusedHighlightColor = -146327;
        public int unfocusedHighlightColor = -3026479;
        public int borderWidth;
        public int focusedBorderColor = -5801984;
        public int unfocusedBorderColor = -10066330;

        public boolean acceptFocus() {
            if (this.acceptsFocus) {
                this.focused = true;
            }
            return this.acceptsFocus;
        }

        public void releaseFocus() {
            this.focused = false;
            this.pressed = false;
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            int n5 = (this.margin >> 24 & 0xFF) + this.borderWidth + this.highlightWidth + (this.padding >> 24 & 0xFF);
            int n6 = (this.margin >> 16 & 0xFF) + this.borderWidth + this.highlightWidth + (this.padding >> 16 & 0xFF);
            int n7 = (this.margin >> 8 & 0xFF) + this.borderWidth + this.highlightWidth + (this.padding >> 8 & 0xFF);
            int n8 = (this.margin & 0xFF) + this.borderWidth + this.highlightWidth + (this.padding & 0xFF);
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            this.contentX = n + n6;
            this.contentY = n2 + n5;
            this.contentWidth = n3 - n6 - n8;
            this.contentHeight = n4 - n5 - n7;
        }

        public void calculateBounds(int n, int n2, int n3, int n4) {
            int n5 = (this.margin >> 24 & 0xFF) + this.borderWidth + this.highlightWidth + (this.padding >> 24 & 0xFF);
            int n6 = (this.margin >> 16 & 0xFF) + this.borderWidth + this.highlightWidth + (this.padding >> 16 & 0xFF);
            int n7 = (this.margin >> 8 & 0xFF) + this.borderWidth + this.highlightWidth + (this.padding >> 8 & 0xFF);
            int n8 = (this.margin & 0xFF) + this.borderWidth + this.highlightWidth + (this.padding & 0xFF);
            this.calculateContentBounds(n + n6, n2 + n5, n3 - n6 - n8, n4 - n5 - n7);
            this.setBounds(this.x - n6, this.y - n5, this.width + n6 + n8, this.height + n5 + n7);
        }

        protected void calculateContentBounds(int n, int n2, int n3, int n4) {
            this.setBounds(n, n2, n3, n4);
        }

        public boolean intersects(int n, int n2, int n3, int n4) {
            int n5 = n + n3;
            int n6 = n2 + n4;
            return n < this.x + this.width && n5 > this.x && n2 < this.y + this.height && n6 > this.y;
        }

        public void initialize() {
        }

        public void draw() {
            this.drawBefore();
            this.drawContent();
            this.drawAfter();
        }

        protected void drawBefore() {
            int n;
            PMIDlet.this.noStroke();
            if (this.bgColor != 0) {
                PMIDlet.this.fill(this.bgColor);
                PMIDlet.this.rect(this.x, this.y, this.width, this.height);
            }
            int n2 = this.pressed ? this.pressedFgColor : (n = this.focused ? this.focusedFgColor : this.unfocusedFgColor);
            if (n != 0) {
                PMIDlet.this.fill(n);
                int n3 = this.margin >> 24 & 0xFF;
                int n4 = this.margin >> 16 & 0xFF;
                int n5 = this.margin >> 8 & 0xFF;
                int n6 = this.margin & 0xFF;
                PMIDlet.this.rect(this.x + n3, this.y + n4, this.width - n4 - n6, this.height - n3 - n5);
            }
        }

        protected void drawContent() {
        }

        protected void drawAfter() {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7 = this.margin >> 24 & 0xFF;
            int n8 = this.margin >> 16 & 0xFF;
            int n9 = this.margin >> 8 & 0xFF;
            int n10 = this.margin & 0xFF;
            if (this.highlightWidth > 0) {
                int n11 = n6 = this.focused ? this.focusedHighlightColor : this.unfocusedHighlightColor;
                if (n6 != 0) {
                    PMIDlet.this.stroke(n6);
                    PMIDlet.this.noFill();
                    n5 = this.x + n8;
                    n4 = this.y + n7;
                    n3 = this.width - n8 - n10 - 1;
                    n2 = this.height - n7 - n9 - 1;
                    for (n = this.highlightWidth - 1; n >= 0; --n) {
                        PMIDlet.this.rect(n5 + n, n4 + n, n3 - (n << 1), n2 - (n << 1));
                    }
                }
                n7 += this.highlightWidth;
                n8 += this.highlightWidth;
                n9 += this.highlightWidth;
                n10 += this.highlightWidth;
            }
            if (this.borderWidth > 0) {
                int n12 = n6 = this.focused ? this.focusedBorderColor : this.unfocusedBorderColor;
                if (n6 != 0) {
                    PMIDlet.this.stroke(n6);
                    PMIDlet.this.noFill();
                    n5 = this.x + n8;
                    n4 = this.y + n7;
                    n3 = this.width - n8 - n10 - 1;
                    n2 = this.height - n7 - n9 - 1;
                    for (n = this.borderWidth - 1; n >= 0; --n) {
                        PMIDlet.this.rect(n5 + n, n4 + n, n3 - (n << 1), n2 - (n << 1));
                    }
                }
            }
        }

        public boolean keyPressed() {
            return false;
        }

        public boolean keyReleased() {
            return false;
        }
    }

    private static class TextInputForm
    extends TextBox
    implements CommandListener {
        private PMIDlet midlet;
        private Command cmdOk;
        private Command cmdCancel;
        private boolean cancelled;

        public TextInputForm(PMIDlet pMIDlet, String string, String string2, int n, int n2) {
            super(string, string2, n, n2);
            this.midlet = pMIDlet;
            this.cmdOk = new Command("OK", 4, 1);
            this.cmdCancel = new Command("Cancel", 3, 2);
            this.addCommand(this.cmdOk);
            this.addCommand(this.cmdCancel);
            this.setCommandListener(this);
        }

        public String getString() {
            String string = this.cancelled ? null : super.getString();
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commandAction(Command command, Displayable displayable) {
            if (command == this.cmdCancel) {
                this.cancelled = true;
            }
            PMIDlet pMIDlet = this.midlet;
            synchronized (pMIDlet) {
                this.midlet.notifyAll();
            }
        }
    }
}

